<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif: xslShowHelp" />
    <xsl:include href="../format.xsl"/>
    <xsl:param name="xslResourceDirectory" select="cif:xslResourceDirectory"/>
    <!-- Curve Set Table Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslResourceDirectory}/engtheme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Curve Set Table Report</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Curve Set Table Report</h2>
                                <p lang="en">
                                    Report Created:&#xa0; <xsl:value-of select="cif:date()"/>
                                    <br/>
                                    Time:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Project:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Description:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@description"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">File Name:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@file"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Last Revised:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor"/>
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Note:&#xa0; </strong>All units in this report are in
                                                <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                                                unless specified otherwise.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <xsl:for-each select="HorizontalAlignment[HorizontalCurveSets]">
                                  <table class="margin" width="90%">
                                    <colgroup span="5">
                                      <col width="18%"/>
                                      <col width="13%"/>
                                      <col width="25%"/>
                                      <col width="22%"/>
                                      <col width="22%"/>
                                    </colgroup>
                                    <tbody>
                                    <tr>
                                      <th align="right" colspan="2" lang="en">Alignment Name:&#xa0;</th>
                                      <td align="left" colspan="3" valign="bottom">
                                        <xsl:value-of select="@name"/>
                                      </td>
                                    </tr>
                                    <tr>
                                      <th align="right" colspan="2" lang="en">Alignment Description:&#xa0;</th>
                                      <td align="left" colspan="3">
                                        <xsl:value-of select="@description"/>
                                      </td>
                                    </tr>
                                    <tr>
                                      <th align="right" colspan="2" lang="en">Alignment Style:&#xa0;</th>
                                      <td align="left" colspan="3">
                                        <xsl:value-of select="@style"/>
                                      </td>
                                    </tr>
                                  </tbody>
                                </table>
                                  <br/>
                                  <table width="90%" border ="1" cellspacing="0" cellpadding ="2">
                                    <tbody>
				      <tr>
                                         <th colspan="12">SPIRAL TABLE</th> 
                                      </tr>
                                      <tr>
                                        <th>PI STATION</th>
                                        <th>DELTA</th>
                                        <th>Ts</th>
                                        <th>DELTAc</th>
                                        <th>Dc</th>
                                        <th>Tc</th>
                                        <th>Lc</th>
                                        <th>Rc</th>
                                        <th>THETA</th>
                                        <th>Ls</th>
                                        <th>LT</th>
                                        <th>ST</th>
                                      </tr>
                                      <xsl:apply-templates/>
                                    </tbody>
                                    </table>                                  
                              <br/>
                                    </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
      <xsl:template match="CurvesetPoint[@pointType != 'POB' and @pointType != 'POE' and @pointType != 'PI']">
            <xsl:choose>
            <xsl:when test="@pointType = 'SPIRAL CIRCLE SPIRAL'">
              <!--<br/>Curve Set Type: <xsl:value-of select="@pointType"/><br/><br/>-->
                  <tr>
                    <!--<td align="right">
                      <xsl:value-of select="GeometryPoint/@type"/>
                    </td>-->
                    <!--<td align="right">
                      ( <xsl:value-of select="GeometryPoint/@name"/> )
                    </td>-->
                    <td align="right">
                      <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(Start/station/@externalStationName))"/>
                    </td>
                    <!--<td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@northing))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(GeometryPoint/@easting))"/>
                    </td>-->
                  <!--</tr>-->
                  <!--<tr>
                    <td align="right">
                      <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@type"/>
                    </td>
                    <td align="right">
                      ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@name"/> )
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/station/@externalStation), string(Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@northing))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@easting))"/>
                    </td>
                  </tr>-->
                  <!--<tr>
                    <td align="right">
                      <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@type"/>
                    </td>-->
                    <!--<td align="right">
                      ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@name"/> )
                    </td>-->
                    <!--<td align="right">
                      <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/station/@externalStation), string(Start/station/@externalStationName))"/>
                    </td>-->
                    <!--<td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@northing))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@easting))"/>
                    </td>
                  </tr>-->
                  <!--<tr>
                    <td align="right">
                      <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@type"/>
                    </td>
                    <td align="right">
                      ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@name"/> )
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/station/@externalStation), string(Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@northing))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@easting))"/>
                    </td>
                  </tr>-->
                  <!--<tr>
                    <td align="right">
                      <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@type"/>
                    </td>
                    <td align="right">
                      ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@name"/> )
                    </td>
                    <td/>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@northing))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@easting))"/>
                    </td>
                  </tr>-->
                  <!--<tr>
                    <td align="right">
                      <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/Start/@type"/>
                    </td>
                    <td align="right">
                      ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/Start/@name"/> )
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/Start/station/@externalStation), string(End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/Start/@northing))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/Start/@easting))"/>
                    </td>
                  </tr>-->
                  <!--<tr>
                    <td align="right">
                      <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/PI/@type"/>
                    </td>
                    <td align="right">
                      ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/PI/@name"/> )
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/PI/station/@externalStation), string(End/station/@externalStationName))"/>
                    </td>
                    <<td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/PI/@northing))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/PI/@easting))"/>
                    </td>
                  </tr>-->
                  <!--<tr>
                    <td align="right">
                      <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/End/@type"/>
                    </td>
                    <td align="right">
                      ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/End/@name"/> )
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/End/station/@externalStation), string(End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/End/@northing))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:ordinateFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/End/@easting))"/>
                    </td>
                  </tr>-->
                  <!--<tr>
                    <td colspan="5">&#xa0;</td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Total Central Angle:</td>-->
                    <td align="right">
                      <xsl:value-of select="cif:angularFormat(number(@delta))"/>
                    <!--</td>
                    <td align="left" lang="en">-->
                      <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection='cw'"> Right</xsl:if>
                      <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection = 'ccw'"> Left</xsl:if>
                    </td>
                  <!--</tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">First Subtangent Distance:</td>-->
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(@tangentLengthStart))"/>
                    </td>
                  <!--</tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Second Subtangent Distance:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(@tangentLengthEnd))"/>
                    </td>-->
                    <!--<tr>
                      <td align="right" colspan="2" lang="en">Delta:</td>-->
                    <td align="right">
                      <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@delta))"/>
                      <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection='cw'"> Right</xsl:if>
                      <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection = 'ccw'"> Left</xsl:if>
                    </td>
                    <!--<tr>
                      <td align="right" colspan="2" lang="en">
                        Degree of Curvature
                        (<xsl:value-of select="../../@curvatureDefinition"/>):
                      </td>-->
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@degreeOfCurve))"/>
                      </td>
                    <!--<tr>
                      <td align="right" colspan="2" lang="en">Tangent:</td>-->
                      <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@tangentLength))"/>
                      </td>
                    <!--<tr>
                      <td align="right" colspan="2" lang="en">Length:</td>-->
                      <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@length))"/>
                      </td>
                    <!--<tr>
                      <td align="right" colspan="2" lang="en">Radius:</td>-->
                      <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@radius))"/>
                      </td>
                    <!--<tr>
                      <td align="right" colspan="2" lang="en">Angle:</td>  THETA??-->
                      <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@thetaAngle))"/>
                      </td>
                      <!--<td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@thetaAngle))"/>
                      </td>
                    </tr>-->
                    <!--<tr>
                      <td align="right" colspan="2" lang="en">Length:</td>-->
                      <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@length))"/>
                      </td>
                      <!--<td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@length))"/>
                      </td>
                    </tr>-->
                    <!--<tr>
                      <td align="right" colspan="2" lang="en">Long Tangent:</td>-->
                      <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@longTangent))"/>
                      </td>
                      <!--<td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@longTangent))"/>
                      </td>
                    </tr>
                    <tr>-->
                      <!--<td align="right" colspan="2" lang="en">Short Tangent:</td>-->
                      <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@shortTangent))"/>
                      </td>
                      <!--<td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@shortTangent))"/>
                      </td>-->



                  </tr>
                  <!--<tr>
                    <td align="right" colspan="2" lang="en">External:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(@external))"/>
                    </td>
                  </tr>
                  <tr>
                    <td colspan="5">&#xa0;</td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Spiral Type:</td>
                    <td align="right">
                      <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@type"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@type"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Constant:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@aConstant))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@aConstant))"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Long Chord:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@longChord))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@longChord))"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Xs:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@xs))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@xs))"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Ys:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@ys))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@ys))"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">P:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@p))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@p))"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">K:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@ks))"/>
                    </td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStopElement]/@ks))"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Delta:</td>
                    <td align="right">
                      <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@delta))"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Chord:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@chord))"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">Middle Ordinate:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@middleOrdinate))"/>
                    </td>
                  </tr>
                  <tr>
                    <td align="right" colspan="2" lang="en">External:</td>
                    <td align="right">
                      <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@externalDistance))"/>
                    </td>
                  </tr>-->
            </xsl:when>
            <xsl:otherwise>
                <!--<tr>
                    <td align="left" colspan="2" lang="en" style="color:red">*** Unsupported element ***</td>
                </tr>-->
            </xsl:otherwise>
        </xsl:choose>
      </xsl:template>
  <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
                You must include at least one horizontal alignment with at least one curve in the <em>
                Include</em> field on the <em>Tools &gt; XML Reports &gt; Geometry</em> command to get 
                results from this report.
            </p>
            <p class="normal1" lang="en">
                This report is not suitable for XML data produced by versions earlier than V8.8.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
